#include <stdio.h>
#include <assert.h>
#include <string.h>

#define ARRSIZE 80

int
main(int argc, char **argv)
{
	char arr[ARRSIZE];
	char *ofilename;
	char *ifilename;
	char *dfilename;
	FILE *ifile;
	FILE *ofile;
	FILE *depfile;
	size_t bytes;
	unsigned int i;

	if (argc != 4) {
		fprintf(stderr, "%s <input file> <output file> <dependency file>\n", argv[0]);
		return 1;
	}
	ifilename = argv[1];
	ofilename = argv[2];
	dfilename = argv[3];
	ifile = fopen(argv[1], "r");
	if (!ifile) {
		fprintf(stderr, "Could not open source file %s.\n", argv[1]);
		return 1;
	}
	ofile = fopen(ofilename, "w");
	if (!ofile) {
		fprintf(stderr, "Could not open target file %s\n", ofilename);
		fclose(ifile);
		return 1;
	}
	bytes = fread(arr, 1, ARRSIZE, ifile);
	assert(bytes < 80);
	assert(bytes > 0);
	fwrite(arr, 1, bytes, ofile);

	depfile = fopen(dfilename, "w");
	if (!depfile) {
		fprintf(stderr, "Could not open depfile %s\n", ofilename);
		fclose(ifile);
		fclose(ofile);
		return 1;
	}
	for (i = 0; i < strlen(ofilename); i++) {
		if (ofilename[i] == ' ') {
			fwrite("\\ ", 1, 2, depfile);
		} else {
			fwrite(&ofilename[i], 1, 1, depfile);
		}
	}
	fwrite(": ", 1, 2, depfile);
	for (i = 0; i < strlen(ifilename); i++) {
		if (ifilename[i] == ' ') {
			fwrite("\\ ", 1, 2, depfile);
		} else {
			fwrite(&ifilename[i], 1, 1, depfile);
		}
	}
	fwrite("\n", 1, 1, depfile);

	fclose(ifile);
	fclose(ofile);
	fclose(depfile);
	return 0;
}
